/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AccelerationAP
extends AP6
implements MouseListener,
MouseMotionListener {
    String[][] text = new String[][]{{"de", "Bewegung mit konstanter Geschwindigkeit", "Zur\u00fcck", "Start", "Pause", "Weiter", "Zeitlupe", "Anfangsposition:", "Anfangsgeschwindigkeit:", "Beschleunigung:", "Geschwindigkeitsvektor", "Beschleunigungsvektor", "(in s)", "(in m)", "(in m/s)", "(in m/s\u00b2)", ""}, {"en", "Motion with Constant Acceleration", "Reset", "Start", "Pause", "Resume", "Slow motion", "Initial position:", "Initial velocity:", "Acceleration:", "Vector of velocity", "Vector of acceleration", "(in s)", "(in m)", "(in m/s)", "(in m/s\u00b2)", ""}};
    final int width = 780;
    final int height = 400;
    final int width0 = 540;
    private int[] gaps = new int[]{10, 5, 10, 10, 0, 10, 0, 10, 0, 10, 0, 10, 0, 10};
    Font fC;
    FontMetrics fmH;
    FontMetrics fmC;
    CanvasAP cv;
    Panel6 pan;
    ResetButton bReset;
    StartButton bStart;
    JCheckBox cbSlow;
    JRadioButton rbV;
    JRadioButton rbA;
    JTextField tfX0;
    JTextField tfV0;
    JTextField tfA;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton1;
    Color colorButton2;
    Color colorPosition;
    Color colorVelocity;
    Color colorAcceleration;
    Color colorLightBarrier1;
    Color colorLightBarrier2;
    Color colorCar1;
    Color colorCar2;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    String text11;
    String text12;
    String text13;
    String text14;
    double t;
    boolean on;
    boolean slow;
    double x0;
    double x;
    double xx;
    double v0;
    double v;
    double a;
    int nrLB;
    double xLB1;
    double xLB2;
    double tLB1;
    double tLB2;
    final int xS = 50;
    final int yS = 60;
    final int PIX = 8;
    final int PIXT = 8;
    final int PIXX = 2;
    final int PIXV = 3;
    final int PIXA = 30;
    double[] xCar;
    double[] yCar;
    double[] xWindow;
    double[] yWindow;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(780, 400);
    }

    @Override
    protected void initAttributes() {
        this.slow = false;
        this.on = false;
        this.t = 0.0;
        this.x0 = 0.0;
        this.v0 = 0.0;
        this.a = 1.0;
        this.xLB1 = 25.0;
        this.xLB2 = 50.0;
        this.nrLB = 0;
        this.initPolygons();
        this.fC = new Font("Monospaced", 1, 16);
        this.fmC = this.getFontMetrics(this.fC);
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton1 = this.getColor(Color.cyan, "colorButton1");
        this.colorButton2 = this.getColor(Color.yellow, "colorButton2");
        this.colorPosition = this.getColor(Color.red, "colorPosition");
        this.colorVelocity = this.getColor(Color.magenta, "colorVelocity");
        this.colorAcceleration = this.getColor(Color.blue, "colorAcceleration");
        this.colorLightBarrier1 = this.getColor(Color.green, "colorLightBarrier1");
        this.colorLightBarrier2 = this.getColor(Color.red, "colorLightBarrier2");
        this.colorCar1 = this.getColor(new Color(192, 192, 192), "colorCar1");
        this.colorCar2 = this.getColor(Color.cyan, "colorCar2");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(this.text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.text11 = this.getText(t[12], "text11");
        this.text12 = this.getText(t[13], "text12");
        this.text13 = this.getText(t[14], "text13");
        this.text14 = this.getText(t[15], "text14");
        this.coauthor = this.getText(t[16], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 540, 400);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(540, 0, 240, 400);
        this.bReset = new ResetButton(this.text01);
        this.pan.add(this.bReset, this.colorButton1, Color.black);
        this.bStart = new StartButton(this.text02, this.text03, this.text04);
        this.pan.add(this.bStart, this.colorButton2, Color.black);
        this.cbSlow = new JCheckBox(this.text05);
        this.pan.add(this.cbSlow, this.bgPanel, Color.black);
        this.pan.add(this.text06);
        this.tfX0 = new JTextField();
        this.tfX0.setText(this.toString(this.x0, 2));
        this.pan.add(this.tfX0, Color.white, 0, 1, 10, 0);
        JLabel lbUnit = new JLabel(this.meter);
        this.pan.add(lbUnit, this.bgPanel, 1, 1, 5, 10);
        this.pan.add(this.text07);
        this.tfV0 = new JTextField();
        this.tfV0.setText(this.toString(this.v0, 2));
        this.pan.add(this.tfV0, Color.white, 0, 1, 10, 0);
        lbUnit = new JLabel(this.meterPerSecond);
        this.pan.add(lbUnit, this.bgPanel, 1, 1, 5, 10);
        this.pan.add(this.text08);
        this.tfA = new JTextField();
        this.tfA.setText(this.toString(this.a, 2));
        this.pan.add(this.tfA, Color.white, 0, 1, 10, 0);
        lbUnit = new JLabel(this.meterPerSecond2);
        this.pan.add(lbUnit, this.bgPanel, 1, 1, 5, 10);
        ButtonGroup bg = new ButtonGroup();
        this.rbV = new JRadioButton(this.text09, true);
        bg.add(this.rbV);
        this.pan.add(this.rbV, this.bgPanel, Color.black);
        this.rbA = new JRadioButton(this.text10, false);
        bg.add(this.rbA);
        this.pan.add(this.rbA, this.bgPanel, Color.black);
        this.pan.add(2000);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.bReset.addActionListener(this);
        this.bStart.addActionListener(this);
        this.cbSlow.addActionListener(this);
        this.rbV.addActionListener(this);
        this.rbA.addActionListener(this);
        this.tfA.addActionListener(this);
        this.tfV0.addActionListener(this);
        this.tfX0.addActionListener(this);
        this.cv.addMouseListener(this);
        this.cv.addMouseMotionListener(this);
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            if (this.on) {
                this.cv.repaint();
            }
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            if (this.on) {
                double dt = (double)(t1 - t0) / 1000.0;
                this.t += this.slow ? dt / 10.0 : dt;
            }
            t0 = t1;
        }
    }

    String valToString(String beg, double v, int n, String end) {
        return beg + this.toString(v, n) + end;
    }

    void initPolygons() {
        this.xCar = new double[7];
        this.xCar[0] = 0.0;
        this.xCar[1] = -1.0;
        this.xCar[2] = -8.0;
        this.xCar[3] = -12.0;
        this.xCar[4] = -24.0;
        this.xCar[6] = -30.0;
        this.xCar[5] = -30.0;
        this.yCar = new double[7];
        this.yCar[0] = 58.0;
        this.yCar[2] = 52.0;
        this.yCar[1] = 52.0;
        this.yCar[4] = 46.0;
        this.yCar[3] = 46.0;
        this.yCar[5] = 51.0;
        this.yCar[6] = 58.0;
        this.xWindow = new double[4];
        this.xWindow[0] = -11.0;
        this.xWindow[1] = -14.0;
        this.xWindow[3] = -22.0;
        this.xWindow[2] = -22.0;
        this.yWindow = new double[4];
        this.yWindow[3] = 52.0;
        this.yWindow[0] = 52.0;
        this.yWindow[2] = 49.0;
        this.yWindow[1] = 49.0;
    }

    void translate(double dx) {
        int i = 0;
        while (i < this.xCar.length) {
            int n = i++;
            this.xCar[n] = this.xCar[n] + dx;
        }
        i = 0;
        while (i < this.xWindow.length) {
            int n = i++;
            this.xWindow[n] = this.xWindow[n] + dx;
        }
    }

    double timeLB(double xLB) {
        if (this.a == 0.0) {
            return (xLB - this.x0) / this.v0;
        }
        double diskr = this.v0 * this.v0 + 2.0 * this.a * (xLB - this.x0);
        if (diskr < 0.0) {
            return -1.0;
        }
        double wu = Math.sqrt(diskr);
        double t1 = (-this.v0 + wu) / this.a;
        double t2 = (-this.v0 - wu) / this.a;
        if (this.a < 0.0) {
            double h = t1;
            t1 = t2;
            t2 = h;
        }
        if (t1 > 0.0) {
            return t1;
        }
        if (t2 > 0.0) {
            return t2;
        }
        return -1.0;
    }

    void changeValues() {
        this.a = this.inputTF(this.tfA, -2.0, 2.0, 2);
        this.v0 = this.inputTF(this.tfV0, -10.0, 10.0, 2);
        this.x0 = this.inputTF(this.tfX0, 0.0, 50.0, 2);
        this.tLB1 = this.timeLB(this.xLB1);
        this.tLB2 = this.timeLB(this.xLB2);
    }

    void setTF(boolean flag) {
        this.tfA.setEnabled(flag);
        this.tfV0.setEnabled(flag);
        this.tfX0.setEnabled(flag);
    }

    double getX0() {
        return this.x0;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.slow = this.cbSlow.isSelected();
        Object o = ae.getSource();
        if (o == this.bReset) {
            this.bStart.setState(0);
            this.setTF(true);
            this.t = 0.0;
        } else if (o == this.bStart) {
            this.bStart.setState();
            this.setTF(false);
            this.changeValues();
        } else if (o instanceof JTextField) {
            this.changeValues();
        }
        this.on = this.bStart.getState() == 1;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        if (y > 60 || y < 40) {
            this.nrLB = 0;
            return;
        }
        double min = (int)Math.abs((double)x - (50.0 + this.xLB1 * 8.0));
        this.nrLB = 1;
        double d = Math.abs((double)x - (50.0 + this.xLB2 * 8.0));
        if (d < min) {
            min = d;
            this.nrLB = 2;
        }
        if (min > 10.0) {
            this.nrLB = 0;
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int xMin = 50;
        int xMax = 450;
        switch (this.nrLB) {
            case 0: {
                return;
            }
            case 1: {
                xMax = (int)Math.round(50.0 + (this.xLB2 - 1.0) * 8.0);
                break;
            }
            case 2: {
                xMin = (int)Math.round(50.0 + (this.xLB1 + 1.0) * 8.0);
            }
        }
        this.on = false;
        this.t = 0.0;
        this.setTF(true);
        int x = me.getX();
        int y = me.getY();
        if (y > 60 || y < 40) {
            return;
        }
        if (x < xMin) {
            x = xMin;
        }
        if (x > xMax) {
            x = xMax;
        }
        double xLB = (double)(x - 50) / 8.0;
        if (this.nrLB == 1) {
            this.xLB1 = xLB;
        } else {
            this.xLB2 = xLB;
        }
        this.cv.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, AccelerationAP.this.bgCanvas);
            AccelerationAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void horArrow(Graphics2D g, double x0, double y0, double w) {
            CanvasAP.arrow(g, 3.0, x0, y0, x0 + w, y0);
        }

        void street(Graphics2D g) {
            g.setColor(Color.black);
            CanvasAP.line(g, 1.0, 60.0, 538.0, 60.0);
            int xx = 500;
            int yy = 75;
            CanvasAP.arrow(g, 40.0, yy, xx, yy);
            this.alignText(g, "x", this.fH, 1, xx, yy + 15);
            this.alignText(g, AccelerationAP.this.text12, this.fH, 1, xx, yy + 25);
            int pix5 = 40;
            for (int i = 0; i <= 10; ++i) {
                xx = 50 + i * pix5;
                CanvasAP.line(g, xx, yy - 2, xx, yy + 2);
                this.alignText(g, "" + i * 5, this.fH, 1, xx, yy + 15);
            }
        }

        void car(Graphics2D g) {
            AccelerationAP.this.x = AccelerationAP.this.a * AccelerationAP.this.t * AccelerationAP.this.t / 2.0 + AccelerationAP.this.v0 * AccelerationAP.this.t + AccelerationAP.this.x0;
            AccelerationAP.this.v = AccelerationAP.this.a * AccelerationAP.this.t + AccelerationAP.this.v0;
            double xNeu = 50.0 + AccelerationAP.this.x * 8.0;
            double dx = xNeu - AccelerationAP.this.xx;
            AccelerationAP.this.xx = xNeu;
            AccelerationAP.this.translate(dx);
            this.polygon(g, AccelerationAP.this.xCar, AccelerationAP.this.yCar, AccelerationAP.this.colorCar1, true);
            this.polygon(g, AccelerationAP.this.xWindow, AccelerationAP.this.yWindow, AccelerationAP.this.colorCar2, true);
            double yy = 57.0;
            CanvasAP.line(g, xNeu - 18.0, yy, xNeu - 18.0, 48.0);
            CanvasAP.circle(g, xNeu - 23.0, yy, 3.0, Color.black, true);
            CanvasAP.circle(g, xNeu - 7.0, yy, 3.0, Color.black, true);
            CanvasAP.circle(g, xNeu - 16.0, 50.0, 1.0, Color.black, true);
            yy = 54.0;
            if (AccelerationAP.this.rbV.isSelected()) {
                g.setColor(AccelerationAP.this.colorVelocity);
                double vv = AccelerationAP.this.v * 3.0;
                if (AccelerationAP.this.v > 0.0) {
                    this.horArrow(g, xNeu, yy, vv);
                }
                if (AccelerationAP.this.v < 0.0) {
                    this.horArrow(g, xNeu - 30.0, yy, vv);
                }
            } else {
                g.setColor(AccelerationAP.this.colorAcceleration);
                double vv = AccelerationAP.this.a * 30.0;
                if (AccelerationAP.this.a > 0.0) {
                    this.horArrow(g, xNeu, yy, vv);
                }
                if (AccelerationAP.this.a < 0.0) {
                    this.horArrow(g, xNeu - 30.0, yy, vv);
                }
            }
        }

        void lBarrier(Graphics2D g, double x, Color c) {
            this.rectangle(g, 50.0 + x * 8.0 - 2.0, 40.0, 5.0, 20.0, c, true);
        }

        void clock(Graphics2D g, int x, int y, double t, Color c) {
            this.rectangle(g, x - 60, y - 15, 120.0, 30.0, c, true);
            this.rectangle(g, x - 50, y - 10, 100.0, 20.0, Color.black, true);
            g.setColor(Color.red);
            g.setFont(AccelerationAP.this.fC);
            int n = (int)(t / 100.0);
            String s = AccelerationAP.this.valToString("", t -= (double)(100 * n), 3, " s");
            int w = AccelerationAP.this.fmC.stringWidth(s);
            this.setAntiAliasing(g, false);
            g.drawString(s, x - w / 2, y + 5);
            this.setAntiAliasing(g, true);
            g.setFont(this.fH);
        }

        void cosy(Graphics2D g, int x, int y, int yMinus, int yPlus) {
            g.setColor(Color.black);
            CanvasAP.arrow(g, x - 10, y, x + 110, y);
            CanvasAP.arrow(g, x, y - yMinus, x, y - yPlus);
            for (int i = 1; i <= 5; ++i) {
                int xx = x + i * 2 * 8;
                CanvasAP.line(g, xx, y - 3, xx, y + 3);
                this.alignText(g, "" + 2 * i, this.fH, 1, xx, y + 15);
            }
            this.alignText(g, "t", this.fH, 1, x + 105, y + 15);
            this.alignText(g, AccelerationAP.this.text11, this.fH, 1, x + 105, y + 25);
        }

        void diagramTX(Graphics2D g) {
            int xU = 50;
            int yU = 330;
            double pixT = 8.0;
            this.cosy(g, 50, 330, -10, 150);
            for (int i = 1; i <= 6; ++i) {
                int yy = 330 - i * 10 * 2;
                CanvasAP.line(g, 47.0, yy, 53.0, yy);
                this.alignText(g, "" + 10 * i, this.fH, 2, 40, yy + 4);
            }
            g.setColor(AccelerationAP.this.colorPosition);
            this.alignText(g, "x", this.fH, 1, 30, 185);
            this.alignText(g, AccelerationAP.this.text12, this.fH, 1, 30, 195);
            this.alignText(g, AccelerationAP.this.valToString("x = ", AccelerationAP.this.x, 2, " " + AccelerationAP.this.meter), this.fH, 1, 110, 380);
            double xx = 50.0 + AccelerationAP.this.t * 8.0;
            double yy = 330.0 - AccelerationAP.this.x * 2.0;
            if (xx <= 150.0 && yy <= 330.0 && yy >= 190.0) {
                CanvasAP.circle(g, xx, yy, 2.0, AccelerationAP.this.colorPosition, true);
            }
            g.setColor(AccelerationAP.this.colorPosition);
            int x0 = 50;
            int x1 = x0 + 1;
            double y0 = 330.0 - AccelerationAP.this.getX0() * 2.0;
            while ((double)x1 <= xx && x1 <= 150) {
                double tt = (double)(x1 - 50) / pixT;
                AccelerationAP.this.x = AccelerationAP.this.a * tt * tt / 2.0 + AccelerationAP.this.v0 * tt + AccelerationAP.this.getX0();
                double y1 = 330.0 - AccelerationAP.this.x * 2.0;
                if (y0 <= 360.0 && y0 >= 190.0 && y1 <= 360.0 && y1 >= 190.0) {
                    CanvasAP.line(g, x0, y0, x1, y1);
                }
                x0 = x1++;
                y0 = y1;
            }
        }

        void diagramTV(Graphics2D g) {
            int xU = 220;
            int yU = 270;
            this.cosy(g, 220, 270, -70, 90);
            for (int i = -4; i <= 4; ++i) {
                if (i == 0) continue;
                int yy = 270 - i * 5 * 3;
                CanvasAP.line(g, 217.0, yy, 223.0, yy);
                this.alignText(g, "" + 5 * i, this.fH, 2, 210, yy + 4);
            }
            g.setColor(AccelerationAP.this.colorVelocity);
            this.alignText(g, "v", this.fH, 1, 195, 185);
            this.alignText(g, AccelerationAP.this.text13, this.fH, 1, 195, 195);
            this.alignText(g, AccelerationAP.this.valToString("v = ", AccelerationAP.this.v, 2, " " + AccelerationAP.this.meterPerSecond), this.fH, 1, 280, 380);
            double xx = 220.0 + AccelerationAP.this.t * 8.0;
            double yy = 270.0 - AccelerationAP.this.v * 3.0;
            double yy0 = 270.0 - AccelerationAP.this.v0 * 3.0;
            if (xx <= 320.0) {
                CanvasAP.circle(g, xx, yy, 2.0, AccelerationAP.this.colorVelocity, true);
                g.setColor(AccelerationAP.this.colorVelocity);
                CanvasAP.line(g, 220.0, yy0, xx, yy);
            } else {
                yy = 270.0 - (AccelerationAP.this.a * 100.0 / 8.0 + AccelerationAP.this.v0) * 3.0;
                CanvasAP.line(g, 220.0, yy0, 320.0, yy);
            }
        }

        void diagramTA(Graphics2D g) {
            int xU = 390;
            int yU = 270;
            this.cosy(g, 390, 270, -70, 90);
            for (int i = -2; i <= 2; ++i) {
                if (i == 0) continue;
                int yy = 270 - i * 30;
                CanvasAP.line(g, 387.0, yy, 393.0, yy);
                this.alignText(g, "" + i, this.fH, 2, 380, yy + 4);
            }
            g.setColor(AccelerationAP.this.colorAcceleration);
            this.alignText(g, "a", this.fH, 1, 363, 185);
            this.alignText(g, AccelerationAP.this.text14, this.fH, 1, 363, 195);
            this.alignText(g, AccelerationAP.this.valToString("a = ", AccelerationAP.this.a, 2, " " + AccelerationAP.this.meterPerSecond2), this.fH, 1, 450, 380);
            double xx = 390.0 + AccelerationAP.this.t * 8.0;
            double yy = 270.0 - AccelerationAP.this.a * 30.0;
            if (xx <= 490.0) {
                CanvasAP.circle(g, xx, yy, 2.0, AccelerationAP.this.colorAcceleration, true);
                g.setColor(AccelerationAP.this.colorAcceleration);
                CanvasAP.line(g, 390.0, yy, xx, yy);
            } else {
                CanvasAP.line(g, 390.0, yy, 490.0, yy);
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            g.setFont(this.fH);
            this.setAntiAliasing(g2, true);
            this.street(g2);
            this.car(g2);
            this.lBarrier(g2, AccelerationAP.this.xLB1, AccelerationAP.this.colorLightBarrier1);
            this.lBarrier(g2, AccelerationAP.this.xLB2, AccelerationAP.this.colorLightBarrier2);
            this.clock(g2, 80, 150, AccelerationAP.this.t, Color.gray);
            double tt = AccelerationAP.this.t;
            if (AccelerationAP.this.tLB1 > 0.0) {
                tt = Math.min(AccelerationAP.this.t, AccelerationAP.this.tLB1);
            }
            this.clock(g2, 250, 150, tt, AccelerationAP.this.colorLightBarrier1);
            tt = AccelerationAP.this.t;
            if (AccelerationAP.this.tLB2 > 0.0) {
                tt = Math.min(AccelerationAP.this.t, AccelerationAP.this.tLB2);
            }
            this.clock(g2, 420, 150, tt, AccelerationAP.this.colorLightBarrier2);
            this.diagramTX(g2);
            this.diagramTV(g2);
            this.diagramTA(g2);
            g.setColor(Color.black);
            this.alignText(g2, AccelerationAP.this.valToString("x = ", AccelerationAP.this.xLB1, 3, " " + AccelerationAP.this.meter), this.fH, 1, 250, 125);
            this.alignText(g2, AccelerationAP.this.valToString("x = ", AccelerationAP.this.xLB2, 3, " " + AccelerationAP.this.meter), this.fH, 1, 420, 125);
        }
    }
}

